" Unit 3 - Lecture 2 "
"------------------------------------------------------------------------"

" Working with Statistical Distributions "

" Key letter:
  d : PMF P(X = x) / PDF f(x)
  p : CDF = P[X <= x]
  q : Quantile
  r : Simulate a random sample "


"------------------------------------------------------------------------"

" Continuous Distributions "

"------------------------------------------------------------------------"

" 1.) Normal Distribution "

" 
Problem:
Visualize the PDF and CDF of Normal Distribution
for a fix value of Sigma and varying values
of Mu.

Similary,
Visualize the PDF and CDF of Normal Distribution
for a fix value of Mu and varying values
of Sigma.
"

sigma = 1.5
mu = 0

X = seq(-10,10,0.5)

PDF = dnorm(X,mu,sigma)

COL = c("pink","blue","orange","yellow")

plot(X,
     PDF,
     type = "l",
     ylab = "PDF",
     xlim = c(-10,10),
     col = "red")


mu = c(-4,-2,2,4)

for(i in 1:length(mu)){
  
  X = seq(-15,15,0.5)
  PDF = dnorm(X,mu[i],sigma)
  
  lines(X,
        PDF,
        col = COL[i])
  
}


mu = 3
X = seq(-6,10,0.25)
PDF = dnorm(X,mu,sigma)

lines(X,
      PDF,
      type = "l",
      col = "orange")


"------------------------------------------------------------------------"

"
Other Continuous Distributions:
- Exponential: iexp()
- Gamma: igamma()
- LogNormal: ilnorm()
- Beta: ibeta()
- Continuous Uniform: iunif()
- F: if()
- t: it()
- Chi-Sq: ichisq()

Where i = d, p, q, r

"

"------------------------------------------------------------------------"

"
Exam Question:

A random variable Y is assumed
to follow a Gamma Distribution 
with mean 4 and variance 8

(a) Simulate 100 values from 
    the above distribution,
    using the seed as 1. 
    Show the empirical mean, median and mode.
    
(b) Compare your answers in part (a),
    which the population values for 
    the measures of central tendency.
"

"a."
alpha = 2
lambda = 0.5

set.seed(1)
Y = rgamma(100,alpha,lambda)

mean(Y)
median(Y)

K.D = density(Y)
K.D$x[which.max(K.D$y)]

plot(K.D)


"b."

alpha / lambda

qgamma(0.5,alpha,lambda)

(alpha - 1) / lambda


" Example: "
X.NORM = rnorm(1000)
K.D = density(X.NORM)

plot(K.D$x,
     K.D$y,
     type = "l")


"------------------------------------------------------------------------"

" Practise Question "

"
Can you confirm that,

Q = (n - 1)*S^2 / (Sigma^2) ~ Chi-sq(n - 1)


Assume:
1,000 samples,
each of size 50 coming from 
N(mu = 15, sigma = 3)

set.seed(1)

a.)
Create the histogram the Q.

b.)
Superimpose on the histogram a graph of the
Theoretical Distribution.

c.)
Comment on how close our empirical distribution
is to theoretical distribution.
"

"a."
mu = 15
sigma = 3
n = 30
Q = numeric()

set.seed(1)

for(i in 1:1000){
  
  X = rnorm(n,mu,sigma)
  Q[i] = (n - 1)*var(X) / sigma^2
  
}


hist(Q,freq = F,
     ylim = c(0,0.06))

CHI.X = seq(0,80,0.5)
CHI.PDF = dchisq(CHI.X,
                 n - 1)

lines(CHI.X,
      CHI.PDF,
      col = "red")

"------------------------------------------------------------------------"

"
Concept:
Understand Quantile
Understand QQ-Plot
"

X = rexp(1000,0.2)
Y = rnorm(1000)

qqplot(X,Y)
abline(0,1,col = "red",
       lwd = 2)

"------------------------------------------------------------------------"

